Imports Microsoft.VisualBasic
Imports System.Net.Mail
Imports System.Web.Configuration
Imports System.Configuration
Imports System.Net.Mail.SmtpClient


Public Class Utilities


    ''' <summary>
    ''' MailSettings is a struct used to define the mail server information
    ''' </summary>
    Public Structure MailSettings
        Public MailServer As String
        Public MailPort As Integer
        Public MailFrom As String
        Public MailUser As String
        Public MailPassword As String
    End Structure

    ''' <summary>
    ''' GetSmtpSettings is used to retrieve the web.config file values and set them to the struct instance properties
    ''' </summary>
    Private Shared Function GetSmtpSettings() As MailSettings

        Dim SmtpSettings As MailSettings
        SmtpSettings.MailServer = WebConfigurationManager.AppSettings("SmtpServer")
        SmtpSettings.MailFrom = WebConfigurationManager.AppSettings("EmailFrom")
        SmtpSettings.MailPort = CInt(WebConfigurationManager.AppSettings("MailPort"))
        SmtpSettings.MailUser = WebConfigurationManager.AppSettings("MailUser")
        SmtpSettings.MailPassword = WebConfigurationManager.AppSettings("MailPassword")
        Return SmtpSettings

    End Function

    ''' <summary>
    ''' GetCredentials is used to set the network credential values for the email server reference
    ''' </summary>
    Private Shared Function GetCredentials(ByVal SmtpSettings As MailSettings) As System.Net.NetworkCredential
        Dim Wuser As String = SmtpSettings.MailUser
        Dim Wpassword As String = SmtpSettings.MailPassword
        Dim myCredentials As New System.Net.NetworkCredential(Wuser, Wpassword)
        Return myCredentials
    End Function

    ''' <summary>
    ''' SendEmail is used to send an email, with the established settings 
    ''' </summary>
    Public Shared Sub SendEmail(ByVal MsgTo As String, ByVal MsgFrom As String, _
        ByVal MsgSubject As String, ByVal MsgText As String)

        Dim SmtpSettings As MailSettings
        SmtpSettings = GetSmtpSettings()
        Dim SmptCl As New SmtpClient(SmtpSettings.MailServer, _
            SmtpSettings.MailPort)
        SmptCl.Credentials = GetCredentials(SmtpSettings)
        Dim MailMsg As New MailMessage(MsgFrom, MsgTo)
        MailMsg.Subject = MsgSubject
        MailMsg.Body = MsgText

        SmptCl.Send(MailMsg)
    End Sub

End Class

